/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.jei;

import com.lothrazar.cyclic.block.generatoritem.RecipeGeneratorItem;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.ChatUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class GenitemRecipeCategory
implements IRecipeCategory<RecipeGeneratorItem> {
    private static final int FONT = 0x404040;
    private static final ResourceLocation ID = new ResourceLocation("cyclic", "generator_item");
    static final RecipeType<RecipeGeneratorItem> TYPE = new RecipeType(ID, RecipeGeneratorItem.class);
    private IDrawable gui;
    private IDrawable icon;

    public GenitemRecipeCategory(IGuiHelper helper) {
        this.gui = helper.drawableBuilder(new ResourceLocation("cyclic", "textures/jei/generator_item.png"), 0, 0, 118, 32).setTextureSize(118, 32).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.GENERATOR_ITEM.get()));
    }

    public Component getTitle() {
        return ChatUtil.ilang(((Block)BlockRegistry.GENERATOR_ITEM.get()).m_7705_());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.gui;
    }

    public Class<? extends RecipeGeneratorItem> getRecipeClass() {
        return RecipeGeneratorItem.class;
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public RecipeType<RecipeGeneratorItem> getRecipeType() {
        return TYPE;
    }

    public void draw(RecipeGeneratorItem recipe, PoseStack ms, double mouseX, double mouseY) {
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getTicks() + " t", 60.0f, 0.0f, 0x404040);
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getRfPertick() + " RF/t", 60.0f, 10.0f, 0x404040);
        Minecraft.m_91087_().f_91062_.m_92883_(ms, recipe.getEnergyTotal() + " RF", 60.0f, 20.0f, 0x404040);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeGeneratorItem recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 7).addIngredients(recipe.at(0));
    }
}

